/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于模组参数构造
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : caobingxing
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_sdk_module */

function mc_sdk_module() {
    if (!(this instanceof mc_sdk_module)) {
        return new mc_sdk_module();
    }
    function mc_mod_apperance() {
        this.str_led_name = "";
        this.d_pitch = 0;
        this.ui_width = 0;
        this.ui_height = 0;

        this.reset = function () {
            this.str_led_name = "";
            this.d_pitch = 0;
            this.ui_width = 0;
            this.ui_height = 0;
        };
    }
    function mc_mod_electrical() {
        this.str_disp_chip = 0;
        this.str_scan_chip = 0;
        this.vstr_sclk_pin_ary = [];
        this.ui_str_pix_step = 0;
        this.ui_str_grp_mode = 0;
        this.df_max_frq = 0;
        this.b_oe_low_valid = true;
        this.b_close_low_valid = true;
        this.b_tx_low_valid = true;
        this.ui_led_type = 0;
        this.ui_scan_cnt = 0;
        this.ary_clr_msg = [];

        this.reset = function () {
            this.str_disp_chip = 0;
            this.str_scan_chip = 0;
            this.vstr_sclk_pin_ary = [];
            this.ui_str_pix_step = 0;
            this.ui_str_grp_mode = 0;
            this.df_max_frq = 0;
            this.b_oe_low_valid = true;
            this.b_close_low_valid = true;
            this.b_tx_low_valid = true;
            this.ui_led_type = 0;
            this.ui_scan_cnt = 0;
            this.ary_clr_msg = [];
        };
    }

    function mc_mod_pix(x, y, clr) {
        this.u32_img_x = arguments[0] ? x : 0;
        this.u32_img_y = arguments[1] ? y : 0;
        this.c_color = arguments[2] ? clr : "N";

        this.reset = function () {
            this.u32_img_x = 0;
            this.u32_img_y = 0;
            this.c_color = "N";
        };
    }

    function mc_mod_scan() {
        this.vst_pix_ary = [];

        this.reset = function () {
            this.vst_pix_ary = [];
        };
    }

    function mc_mod_str() {
        this.str_str_name = "";
        this.str_pin_name = "";
        this.vst_scan_ary = [];

        this.reset = function () {
            this.str_str_name = "";
            this.str_pin_name = "";
            this.vst_scan_ary = [];
        };
    }

    function mc_mod_dispchip_info() {
        this.str_jump_ic = "-1";
        this.str_ic_channels = "1";
        this.reset = function () {
            this.str_jump_ic = "-1";
            this.str_ic_channels = "1";
        };
    }

    var MODULE_ENTRY = "LEDMOD";

    var MODULE_APPERANCE = "APPERANCE";
    var MODULE_APPE_ATT_LED_NAME = "LED_NAME";
    var MODULE_APPE_ATT_PITCH = "PITCH";
    var MODULE_APPE_ATT_WIDTH = "WIDTH";
    var MODULE_APPE_ATT_HEIGHT = "HEIGHT";

    var MODULE_ELECTRICAL = "ELECTRICAL";
    var MODULE_ELECT_ATT_DISP_CHIP = "DISP_CHIP";
    var MODULE_ELECT_ATT_SCAN_CHIP = "SCAN_CHIP";
    var MODULE_ELECT_ATT_SCLK_PIN_ARY = "SCLK_PIN_ARY";
    var MODULE_ELECT_ATT_STR_PIX_STEP = "STR_PIX_STEP";
    var MODULE_ELECT_ATT_STR_GRP_MODE = "STR_GRP_MODE";
    var MODULE_ELECT_ATT_MAX_FRQ = "MAX_FRQ";
    var MODULE_ELECT_ATT_OE_LOW_VALID = "OE_LOW_VALID";
    var MODULE_ELECT_ATT_CLOSE_LOW_VALID = "CLOSE_LOW_VALID";
    var MODULE_ELECT_ATT_TX_LOW_VALID = "TX_LOW_VALID";

    // var MODULE_SOCKETS = "SOCKETS";
    // var MODULE_SOCKET = "SOCKET";
    // var MODULE_PIN = "PIN";
    // var MODULE_PIN_ATTR_ID = "ID";
    // var MODULE_PIN_ATTR_TYPE = "TYPE";

    var MODULE_PIX_STRS = "PIX_STRS";
    var MODULE_PIX_STR = "PIX_STR";
    var MODULE_PIX_STR_ATTR_ID = "ID";
    var MODULE_PIX_STR_ATTR_PIN_ID = "PIN_ID";
    // var MODULE_PIX_STR_ATTR_PRE_SCAN = "PRE_SCAN";
    // var MODULE_PIX_STR_ATTR_PRE_COLOR = "PRE_COLOR";

    // var MODULE_PIX_COORD_X = "X";
    // var MODULE_PIX_COORD_Y = "Y";
    // var MODULE_PIX_COLOR = "COLOR";
    // var MODULE_PIX_SCAN = "SCAN";

    var MODULE_MAX_STR_CNT = 256;

    // var m_str_descript_xml_dst = "";
    var m_st_mod_apperance = new mc_mod_apperance();
    var m_st_mod_electrical = new mc_mod_electrical();
    var m_vst_str_ary = [];
    var m_cla_xml_doc = new DOMParser();

    var m_st_mod_dispchip_info = new mc_mod_dispchip_info();


    function reset() {
        // m_str_descript_xml_dst = "";
        m_st_mod_electrical = new mc_mod_electrical();
        m_vst_str_ary = [];
        m_cla_xml_doc = new DOMParser();
        m_st_mod_dispchip_info = new mc_mod_dispchip_info();
        return true;
    }

    function set_xml_data(str_xml) {
        if (!str_xml) {
            return false;
        }
        var cla_doc = m_cla_xml_doc.parseFromString(str_xml, "text/xml");

        var b_ret = decode_module_apperance(cla_doc, m_st_mod_electrical);

        if (!b_ret) {
            return false;
        }
        b_ret = decode_module_electrical(cla_doc, m_st_mod_electrical);

        if (!b_ret) {
            return false;
        }
        return decode_module_str(cla_doc);
    }

    function format_input_str(str) {
        str = str.replace(/\s+/g, "");
        str = str.replace(/，/g, ",");
        str = str.toUpperCase();
        return str;
    }

    function decode_module_apperance(cla_doc) {
        var pcla_ledmod_entry = cla_doc.getElementsByTagName(MODULE_ENTRY);

        if (!pcla_ledmod_entry.length) {
            return false;
        }
        var pcla_elem_appes = pcla_ledmod_entry[0].getElementsByTagName(MODULE_APPERANCE);

        if (!pcla_elem_appes) {
            return false;
        }
        var pcla_elem_appe = pcla_elem_appes[0];
        var ac_attr_val = pcla_elem_appe.getAttribute(MODULE_APPE_ATT_LED_NAME);

        if (ac_attr_val) {
            m_st_mod_apperance.str_led_name = ac_attr_val;
        }

        ac_attr_val = pcla_elem_appe.getAttribute(MODULE_APPE_ATT_PITCH);
        if (ac_attr_val) {
            m_st_mod_apperance.d_pitch = parseFloat(ac_attr_val);
        }

        ac_attr_val = pcla_elem_appe.getAttribute(MODULE_APPE_ATT_WIDTH);
        if (ac_attr_val) {
            m_st_mod_apperance.ui_width = parseInt(ac_attr_val, 10);
        }

        ac_attr_val = pcla_elem_appe.getAttribute(MODULE_APPE_ATT_HEIGHT);
        if (ac_attr_val) {
            m_st_mod_apperance.ui_height = parseInt(ac_attr_val, 10);
        }
        return true;
    }

    function decode_module_electrical(cla_doc) {
        var pcla_ledmod_entry = cla_doc.getElementsByTagName(MODULE_ENTRY);

        if (!pcla_ledmod_entry.length) {
            return false;
        }
        var pcla_elem_entrys = pcla_ledmod_entry[0].getElementsByTagName(MODULE_ELECTRICAL);

        if (!pcla_elem_entrys.length) {
            return false;
        }
        var pcla_elem_entry = pcla_elem_entrys[0];
        var ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_DISP_CHIP);

        if (ac_attr_val) {
            m_st_mod_electrical.str_disp_chip = ac_attr_val;
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_SCAN_CHIP);
        if (ac_attr_val) {
            m_st_mod_electrical.str_scan_chip = ac_attr_val;
        }

        m_st_mod_electrical.vstr_sclk_pin_ary = [];
        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_SCLK_PIN_ARY);
        if (ac_attr_val) {
            ac_attr_val = format_input_str(ac_attr_val);
            m_st_mod_electrical.vstr_sclk_pin_ary = ac_attr_val.split(",").filter(function (e) {
                return e.length;
            });
        }
        if (1 > m_st_mod_electrical.vstr_sclk_pin_ary.length) {
            m_st_mod_electrical.vstr_sclk_pin_ary.push("SCLK");
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_STR_PIX_STEP);
        if (ac_attr_val) {
            m_st_mod_electrical.ui_str_pix_step = parseInt(ac_attr_val, 10);
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_STR_GRP_MODE);
        if (ac_attr_val) {
            m_st_mod_electrical.ui_str_grp_mode = parseInt(ac_attr_val, 10);
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_MAX_FRQ);
        if (ac_attr_val) {
            m_st_mod_electrical.df_max_frq = parseFloat(ac_attr_val);
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_OE_LOW_VALID);
        if (ac_attr_val) {
            m_st_mod_electrical.b_oe_low_valid = false;
            if ("TRUE" === ac_attr_val.toUpperCase()) {
                m_st_mod_electrical.b_oe_low_valid = true;
            }
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_CLOSE_LOW_VALID);
        if (ac_attr_val) {
            m_st_mod_electrical.b_close_low_valid = false;
            if ("TRUE" === ac_attr_val.toUpperCase()) {
                m_st_mod_electrical.b_close_low_valid = true;
            }
        }

        ac_attr_val = pcla_elem_entry.getAttribute(MODULE_ELECT_ATT_TX_LOW_VALID);
        if (ac_attr_val) {
            m_st_mod_electrical.b_tx_low_valid = false;
            if ("TRUE" === ac_attr_val.toUpperCase()) {
                m_st_mod_electrical.b_tx_low_valid = true;
            }
        }
        return true;
    }

    function add_pix_to_mod_str(point) {
        var pix = new mc_mod_pix(point.x, point.y, point.color);

        if (!this.vst_scan_ary[point.scan_idx]) {
            this.vst_scan_ary[point.scan_idx] = new mc_mod_scan();
        }
        this.vst_scan_ary[point.scan_idx].vst_pix_ary.push(pix);
    }

    function decode_module_str(cla_doc) {
        var pcla_ledmod_entry = cla_doc.getElementsByTagName(MODULE_ENTRY);

        if (!pcla_ledmod_entry.length) {
            return false;
        }

        var pcla_elem_entry = pcla_ledmod_entry[0].getElementsByTagName(MODULE_PIX_STRS);

        if (!pcla_elem_entry.length) {
            return false;
        }
        var pcla_str_entry = pcla_elem_entry[0].getElementsByTagName(MODULE_PIX_STR);

        for (var i = 0; i < pcla_str_entry.length; i++) {
            var ac_get_value = pcla_str_entry[i].textContent;

            if (ac_get_value.length) {
                ac_get_value = format_input_str(ac_get_value);
                var arr = ac_get_value.split(",").filter(function (e) {
                    return e.length;
                });
                var point = arr.map(function (e) {
                    var a = e.slice(1, e.length - 1).split(":");
                    var res = {};

                    res.x = parseInt(a[0], 10);
                    res.y = parseInt(a[1], 10);
                    if ("R" === a[2]) {
                        res.color = "R";
                    } else if ("G" === a[2]) {
                        res.color = "G";
                    } else if ("B" === a[2]) {
                        res.color = "B";
                    } else {
                        res.color = "V";
                    }
                    res.scan_idx = parseInt(a[3], 10);
                    return res;
                });
                var mod_str = new mc_mod_str();

                point.forEach(add_pix_to_mod_str, mod_str);
                m_vst_str_ary[i] = mod_str;
            }

            var ac_attr_val = pcla_str_entry[i].getAttribute(MODULE_PIX_STR_ATTR_ID);

            if (ac_attr_val && m_vst_str_ary.length - 1 === i) {
                m_vst_str_ary[i].str_str_name = ac_attr_val;
            }

            ac_attr_val = pcla_str_entry[i].getAttribute(MODULE_PIX_STR_ATTR_PIN_ID);
            if (ac_attr_val && m_vst_str_ary.length - 1 === i) {
                m_vst_str_ary[i].str_pin_name = ac_attr_val;
            }
        }
        return true;
    }

    function get_xml_data() {
        var m_str_descript_xml_dst = "";

        m_str_descript_xml_dst += "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        m_str_descript_xml_dst += "<" + MODULE_ENTRY + " VERSION=\"1.0\">\n";
        var str_pin_ary = "";

        for (var i = 0; i < m_st_mod_electrical.vstr_sclk_pin_ary.length; i++) {
            if (m_st_mod_electrical.vstr_sclk_pin_ary[i].length) {
                str_pin_ary += m_st_mod_electrical.vstr_sclk_pin_ary[i] + ",";
            }
        }
        /* apperance */
        m_str_descript_xml_dst += "  <" + MODULE_APPERANCE + " " +
            MODULE_APPE_ATT_LED_NAME + "=\"" + m_st_mod_apperance.str_led_name + "\" " +
            MODULE_APPE_ATT_PITCH + "=\"" + m_st_mod_apperance.d_pitch + "\" " +
            MODULE_APPE_ATT_WIDTH + "=\"" + m_st_mod_apperance.ui_width + "\" " +
            MODULE_APPE_ATT_HEIGHT + "=\"" + m_st_mod_apperance.ui_height + "\" />\n";

        /* electrical */
        m_str_descript_xml_dst += "  <" + MODULE_ELECTRICAL + " " +
            MODULE_ELECT_ATT_DISP_CHIP + "=\"" + m_st_mod_electrical.str_disp_chip + "\" " +
            MODULE_ELECT_ATT_SCAN_CHIP + "=\"" + m_st_mod_electrical.str_scan_chip + "\" " +
            MODULE_ELECT_ATT_SCLK_PIN_ARY + "=\"" + str_pin_ary + "\" " +
            MODULE_ELECT_ATT_STR_PIX_STEP + "=\"" + m_st_mod_electrical.ui_str_pix_step + "\" " +
            MODULE_ELECT_ATT_STR_GRP_MODE + "=\"" + m_st_mod_electrical.ui_str_grp_mode + "\" " +
            MODULE_ELECT_ATT_OE_LOW_VALID + "=\"" + (m_st_mod_electrical.b_oe_low_valid ? "TRUE" : "FALSE") + "\" " +
            MODULE_ELECT_ATT_CLOSE_LOW_VALID + "=\"" + (m_st_mod_electrical.b_close_low_valid ? "TRUE" : "FALSE") + "\" " +
            MODULE_ELECT_ATT_TX_LOW_VALID + "=\"" + (m_st_mod_electrical.b_tx_low_valid ? "TRUE" : "FALSE") + "\" " +
            MODULE_ELECT_ATT_MAX_FRQ + "=\"" + m_st_mod_electrical.df_max_frq + "\" />\n";

        /* write all str */
        m_str_descript_xml_dst += "  <" + MODULE_PIX_STRS + ">\n";
        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            m_str_descript_xml_dst += "    <" + MODULE_PIX_STR + " " +
                MODULE_PIX_STR_ATTR_ID + "=\"" + st_str.str_str_name + "\" " +
                MODULE_PIX_STR_ATTR_PIN_ID + "=\"" + st_str.str_pin_name + "\">\n";

            /* write all scan */
            var str_scan_pix = "";
            var ui_scan_pix_cnt = m_vst_str_ary[idx_str].vst_scan_ary.length;

            for (var idx_scan = 0; idx_scan < ui_scan_pix_cnt; idx_scan++) {
                str_scan_pix += "      ";
                var st_scan = st_str.vst_scan_ary[idx_scan];

                for (var idx_pix = 0; idx_pix < st_scan.vst_pix_ary.length; idx_pix++) {
                    var st_pix = st_scan.vst_pix_ary[idx_pix];

                    str_scan_pix += "(" + st_pix.u32_img_x + ":" + st_pix.u32_img_y + ":" + st_pix.c_color + ":" +
                        idx_scan + "),";
                }
                str_scan_pix += "\n";
            }
            if (0 < str_scan_pix.length && ("\n" === str_scan_pix.slice(-1) || "," === str_scan_pix.slice())) {
                str_scan_pix.slice(0, -1);
            }

            m_str_descript_xml_dst += str_scan_pix + "    </" + MODULE_PIX_STR + ">\n";
        }
        m_str_descript_xml_dst += "</" + MODULE_PIX_STRS + ">\n";

        m_str_descript_xml_dst += "</" + MODULE_ENTRY + ">\n";

        return m_str_descript_xml_dst;
    }

    function equals_str(st_module) {
        var u32_str_cnt = st_module.mc_util_mod_get_str_cnt();

        if (m_vst_str_ary.length !== u32_str_cnt) {
            return false;
        }

        for (var idx_str = 0; idx_str < u32_str_cnt; idx_str++) {
            if (m_vst_str_ary[idx_str].str_pin_name !== st_module.mc_util_mod_get_str_pin(idx_str) ||
                m_vst_str_ary[idx_str].str_str_name !== st_module.mc_util_mod_get_str_name(idx_str)) {
                return false;
            }

            var u32_scan_cnt = st_module.mc_util_mod_get_scan_cnt(idx_str);

            if (m_vst_str_ary[idx_str].vst_scan_ary.length !== u32_scan_cnt) {
                return false;
            }

            for (var idx_scan = 0; idx_scan < u32_scan_cnt; idx_scan++) {
                var u32_pix_cnt = st_module.mc_util_mod_get_pix_cnt(idx_str, idx_scan);

                if (m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary.length !== u32_pix_cnt) {
                    return false;
                }

                for (var idx_pix = 0; idx_pix < u32_pix_cnt; idx_pix++) {
                    var st_pix_src = st_module.mc_util_mod_get_pix_info(idx_str, idx_scan, idx_pix, st_pix_src);

                    var st_pix_cur = m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary[idx_pix];

                    if (st_pix_cur.c_color !== st_pix_src.c_color ||
                        Number(st_pix_cur.u32_img_x) !== Number(st_pix_src.u32_img_x) ||
                        Number(st_pix_cur.u32_img_y) !== Number(st_pix_src.u32_img_y)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    function equals(str_xml) {
        var st_module = new mc_sdk_module();

        st_module.mc_util_mod_set_xml(str_xml);
        if (!(st_module instanceof mc_sdk_module)) {
            return false;
        }
        if (st_module === this) {
            return true;
        }
        if (m_st_mod_electrical.vstr_sclk_pin_ary.length !== st_module.mc_util_mod_get_sclk_pin_cnt()) {
            return false;
        }

        for (var idx_pin = 0; idx_pin < m_st_mod_electrical.vstr_sclk_pin_ary.length; idx_pin++) {
            if (st_module.mc_util_mod_get_sclk_pin_name(idx_pin) !== m_st_mod_electrical.vstr_sclk_pin_ary[idx_pin]) {
                return false;
            }
        }

        if (m_st_mod_electrical.str_disp_chip !== st_module.mc_util_mod_get_disp_chip() ||
            m_st_mod_electrical.str_scan_chip !== st_module.mc_util_mod_get_scan_chip() ||
            Number(m_st_mod_electrical.ui_str_pix_step) !== Number(st_module.mc_util_mod_get_scan_pix_step()) ||
            parseFloat(m_st_mod_electrical.df_max_frq) !== parseFloat(st_module.mc_util_mod_get_max_frequence()) ||
            Number(m_st_mod_electrical.b_tx_low_valid) !== Number(st_module.mc_util_mod_get_tx_low_valid()) ||
            Number(m_st_mod_electrical.b_oe_low_valid) !== Number(st_module.mc_util_mod_get_oe_low_valid()) ||
            Number(m_st_mod_electrical.b_close_low_valid) !== Number(st_module.mc_util_mod_get_close_low_valid()) ||
            Number(m_st_mod_electrical.ui_str_grp_mode) !== Number(st_module.mc_util_mod_get_str_grp_mode())) {
            return false;
        }

        return equals_str(st_module);
    }

    function set_mod(st_src_module, u32_scan_sta_pos, u32_scan_end_pos) {
        if (isNaN(parseInt(u32_scan_sta_pos, 10)) || isNaN(parseInt(u32_scan_end_pos, 10))) {
            return false;
        }
        if (u32_scan_sta_pos > u32_scan_end_pos) {
            var u32_tmp = u32_scan_end_pos;

            u32_scan_end_pos = u32_scan_sta_pos;
            u32_scan_sta_pos = u32_tmp;
        }
        m_st_mod_electrical = st_src_module.mc_util_mod_get_electrica();
        m_vst_str_ary = st_src_module.mc_util_mod_get_str_ary();

        var ui_str_cnt = m_vst_str_ary.length;

        for (var idx_str = 0; idx_str < ui_str_cnt; idx_str++) {
            var ui_scan_cnt = m_vst_str_ary[idx_str].vst_scan_ary.length;

            for (var idx_scan = 0; idx_scan < ui_scan_cnt; idx_scan++) {
                var vst_pix_ary = m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary;
                var ui_pix_cnt = vst_pix_ary.length;

                if (0 < u32_scan_sta_pos && u32_scan_sta_pos < ui_pix_cnt) {
                    vst_pix_ary.splice(0, u32_scan_sta_pos - 1);
                }
                /* 注意这里要用减一，因为有可能 u32_scan_end_pos 为全1 */
                if (0 < u32_scan_end_pos && u32_scan_end_pos < ui_pix_cnt - 1) {
                    vst_pix_ary.length = u32_scan_end_pos + 1 - u32_scan_sta_pos;
                }
            }
        }
        return true;
    }

    function set_led_name(ac_led_name) {
        m_st_mod_apperance.str_led_name = "";
        if (ac_led_name) {
            m_st_mod_apperance.str_led_name = ac_led_name;
            return true;
        }
        return false;
    }

    function get_led_name() {
        return m_st_mod_apperance.str_led_name;
    }

    function set_pitch(ac_pitch) {
        m_st_mod_apperance.d_pitch = "";
        if (ac_pitch) {
            m_st_mod_apperance.d_pitch = parseFloat(ac_pitch);
            return true;
        }
        return false;
    }

    function get_pitch() {
        return m_st_mod_apperance.d_pitch;
    }

    function set_width(ac_width) {
        if (
            ac_width ||
            "number" !== typeof ac_width ||
            !isNaN(ac_width)
        ) {
            m_st_mod_apperance.ui_width = parseInt(ac_width, 10);
            return true;
        }
        return false;
    }

    function get_width() {
        return m_st_mod_apperance.ui_width;
    }

    function set_height(ac_height) {
        if (
            ac_height ||
            "number" !== typeof ac_height ||
            !isNaN(ac_height)
        ) {
            m_st_mod_apperance.ui_height = parseInt(ac_height, 10);
            return true;
        }
        return false;
    }

    function get_height() {
        return m_st_mod_apperance.ui_height;
    }

    function set_disp_chip(ac_chip_name) {
        m_st_mod_electrical.str_disp_chip = "";
        if (ac_chip_name) {
            m_st_mod_electrical.str_disp_chip = ac_chip_name;
            return true;
        }
        return false;
    }

    function get_disp_chip() {
        return m_st_mod_electrical.str_disp_chip;
    }

    function set_scan_chip(ac_chip_name) {
        m_st_mod_electrical.str_scan_chip = "";
        if (ac_chip_name) {
            m_st_mod_electrical.str_scan_chip = ac_chip_name;
            return true;
        }
        return false;
    }

    function get_scan_chip() {
        return m_st_mod_electrical.str_scan_chip;
    }

    function set_scan_pix_step(u32_step) {
        if (isNaN(parseInt(u32_step, 10))) {
            return false;
        }
        m_st_mod_electrical.ui_str_pix_step = u32_step;
        return true;
    }

    function get_scan_pix_step() {
        return m_st_mod_electrical.ui_str_pix_step;
    }

    function set_sclk_pin_name(u32_pin_idx, ac_pin_name) {
        if (isNaN(parseInt(u32_pin_idx, 10))) {
            return false;
        }
        if (m_st_mod_electrical.vstr_sclk_pin_ary.length <= u32_pin_idx) {
            m_st_mod_electrical.vstr_sclk_pin_ary.length = u32_pin_idx + 1;
        }
        if (ac_pin_name) {
            m_st_mod_electrical.vstr_sclk_pin_ary[u32_pin_idx] = ac_pin_name.toUpperCase();
            return true;
        }
        return false;
    }

    function get_sclk_pin_name(u32_pin_idx) {
        if (isNaN(parseInt(u32_pin_idx, 10))) {
            return "";
        }
        if (m_st_mod_electrical.vstr_sclk_pin_ary.length <= u32_pin_idx) {
            return "";
        }
        return m_st_mod_electrical.vstr_sclk_pin_ary[u32_pin_idx];
    }

    function get_sclk_pin_cnt() {
        return m_st_mod_electrical.vstr_sclk_pin_ary.length;
    }

    function set_max_frequence(df_max_frq) {
        if (isNaN(parseFloat(df_max_frq))) {
            return false;
        }
        m_st_mod_electrical.df_max_frq = df_max_frq;
        return true;
    }

    function get_max_frequence() {
        return m_st_mod_electrical.df_max_frq;
    }

    function set_oe_low_valid(b_low_valid) {
        m_st_mod_electrical.b_oe_low_valid = b_low_valid;
        return true;
    }

    function get_oe_low_valid() {
        return m_st_mod_electrical.b_oe_low_valid;
    }

    function set_close_low_valid(b_low_valid) {
        m_st_mod_electrical.b_close_low_valid = b_low_valid;
        return true;
    }

    function get_close_low_valid() {
        return m_st_mod_electrical.b_close_low_valid;
    }

    function set_tx_low_valid(b_low_valid) {
        m_st_mod_electrical.b_tx_low_valid = b_low_valid;
        return true;
    }

    function get_tx_low_valid() {
        return m_st_mod_electrical.b_tx_low_valid;
    }

    function get_img_rect(u32_scan_sta_pos, u32_scan_end_pos) {
        var obj_rect = {};

        if (u32_scan_sta_pos > u32_scan_end_pos) {
            var u32_tmp = u32_scan_end_pos;

            u32_scan_end_pos = u32_scan_sta_pos;
            u32_scan_sta_pos = u32_tmp;
        }

        var u32_left = Number.MAX_VALUE;
        var u32_top = Number.MAX_VALUE;
        var u32_right = 0;
        var u32_bottom = 0;

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < st_str.vst_scan_ary.length; idx_scan++) {
                var st_scan = st_str.vst_scan_ary[idx_scan];
                var ui_pix_cnt = st_scan.vst_pix_ary.length;

                /* 注意这里要用减一，因为有可能 u32_scan_end_pos 为全1 */
                if (ui_pix_cnt - 1 > u32_scan_end_pos) {
                    ui_pix_cnt = u32_scan_end_pos + 1;
                }
                for (var idx_pix = u32_scan_sta_pos; idx_pix < ui_pix_cnt; idx_pix++) {
                    var st_pix = st_scan.vst_pix_ary[idx_pix];

                    switch (st_pix.c_color) {
                    case "r":
                    case "R":
                    case "g":
                    case "G":
                    case "b":
                    case "B":
                        if (u32_left > st_pix.u32_img_x) {
                            u32_left = st_pix.u32_img_x;
                        }
                        if (u32_top > st_pix.u32_img_y) {
                            u32_top = st_pix.u32_img_y;
                        }

                        if (u32_right < st_pix.u32_img_x) {
                            u32_right = st_pix.u32_img_x;
                        }
                        if (u32_bottom < st_pix.u32_img_y) {
                            u32_bottom = st_pix.u32_img_y;
                        }
                        break;
                    default:
                        break;
                    }
                }
            }
        }

        if (Number.MAX_VALUE === u32_left || Number.MAX_VALUE === u32_top) {
            obj_rect.u32_left = 0;
            obj_rect.u32_top = 0;
            obj_rect.u32_right = 0;
            obj_rect.u32_bottom = 0;

            return obj_rect;
        }
        obj_rect.u32_left = u32_left;
        obj_rect.u32_top = u32_top;
        obj_rect.u32_right = u32_right;
        obj_rect.u32_bottom = u32_bottom;
        return obj_rect;
    }

    function get_str_cnt() {
        return m_vst_str_ary.length;
    }

    function get_str_max_scan_len(u32_str_idx) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return 0;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            return 0;
        }

        var ui_max_len = 0;

        for (var idx_scan = 0; idx_scan < m_vst_str_ary[u32_str_idx].vst_scan_ary.length; idx_scan++) {
            var st_scan = m_vst_str_ary[u32_str_idx].vst_scan_ary[idx_scan];

            if (st_scan.vst_pix_ary.length > ui_max_len) {
                ui_max_len = st_scan.vst_pix_ary.length;
            }
        }

        return ui_max_len;
    }

    function get_scan_cnt(u32_str_idx) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return 0;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            return 0;
        }

        return m_vst_str_ary[u32_str_idx].vst_scan_ary.length;
    }

    function get_pix_cnt(u32_str_idx, u32_scan_idx) {
        if (isNaN(parseInt(u32_str_idx, 10) || isNaN(parseInt(u32_scan_idx, 10)))) {
            return 0;
        }
        if (m_vst_str_ary.length <= u32_str_idx || m_vst_str_ary[u32_str_idx].vst_scan_ary.length <= u32_scan_idx) {
            return 0;
        }

        return m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary.length;
    }

    function get_max_scan_cnt() {
        var ui_max_len = 0;

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            if (st_str.vst_scan_ary.length > ui_max_len) {
                ui_max_len = st_str.vst_scan_ary.length;
            }
        }

        return ui_max_len;
    }

    function get_max_scan_len() {
        var ui_max_len = 0;

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < st_str.vst_scan_ary.length; idx_scan++) {
                var st_scan = st_str.vst_scan_ary[idx_scan];

                if (st_scan.vst_pix_ary.length > ui_max_len) {
                    ui_max_len = st_scan.vst_pix_ary.length;
                }
            }
        }

        return ui_max_len;
    }

    function get_pix_clr_ary() {
        var str_pix_clr_ary = "";
        var m;

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < str.vst_scan_ary.length; idx_scan++) {
                var scan = str.vst_scan_ary[idx_scan];
                var vst_pix_ary = scan.vst_pix_ary;

                var ui_scan_len = vst_pix_ary.length;

                if (0 === ui_scan_len) {
                    continue;
                }
                var a_pix_clr_ary = Array(ui_scan_len);

                for (var i = 0; i < a_pix_clr_ary.length; i++) {
                    a_pix_clr_ary[i] = "V";
                }
                for (var idx_pix = 0; idx_pix < ui_scan_len; idx_pix++) {
                    switch (vst_pix_ary[idx_pix].c_color) {
                    case "R":
                    case "r":
                        a_pix_clr_ary[idx_pix] = "R";
                        break;
                    case "G":
                    case "g":
                        a_pix_clr_ary[idx_pix] = "G";
                        break;
                    case "B":
                    case "b":
                        a_pix_clr_ary[idx_pix] = "B";
                        break;
                    default:
                        break;
                    }
                }
                str_pix_clr_ary = a_pix_clr_ary.join("");
                m = str_pix_clr_ary.match(/[^V]/g);

                if (m) {
                    break;
                }
            }
            m = str_pix_clr_ary.match(/[^V]/g);
            if (m) {
                break;
            }
        }
        return str_pix_clr_ary;
    }

    function get_combo_size(str_pix_clr_ary) {
        /* 重复块大小 */
        var u32_comb_size = 1;
        var ui_scan_len = str_pix_clr_ary.length;

        for (u32_comb_size = 1; u32_comb_size < ui_scan_len; u32_comb_size++) {
            var str_pix_clr_tmp = str_pix_clr_ary.slice(ui_scan_len % u32_comb_size);
            var b_check_success = true;
            var a_base_clr_ary = str_pix_clr_tmp.slice(0, u32_comb_size).split("");

            for (var idx_clr = u32_comb_size; idx_clr < str_pix_clr_tmp.length; idx_clr += u32_comb_size) {
                for (var idx = 0; idx < u32_comb_size; idx++) {
                    if ("V" !== a_base_clr_ary[idx] &&
                        "V" !== str_pix_clr_tmp[idx_clr + idx] &&
                        a_base_clr_ary[idx] !== str_pix_clr_tmp[idx_clr + idx]) {
                        b_check_success = false;
                        break;
                    }
                    if ("V" === a_base_clr_ary[idx]) {
                        a_base_clr_ary[idx] = str_pix_clr_tmp[idx_clr + idx];
                    }
                }

                if (!b_check_success) {
                    break;
                }
            }

            if (b_check_success) {
                break;
            }
        }
        return u32_comb_size;
    }

    function is_str_has_rgb(str_pix_clr_ary, u32_comb_size, a_block_desc) {
        /* 提取有效重复块，即排除V */
        var ui_block_cnt = str_pix_clr_ary.length / u32_comb_size;

        for (var idx_pix = 0; idx_pix < u32_comb_size; idx_pix++) {
            for (var idx_block = 0; idx_block < ui_block_cnt; idx_block++) {
                var ui_key_pos = idx_block * u32_comb_size + idx_pix;

                if ("V" !== str_pix_clr_ary[ui_key_pos]) {
                    a_block_desc[idx_pix] = str_pix_clr_ary[ui_key_pos];
                    break;
                }
            }
        }

        return a_block_desc.some(function (e) {
            return "R" === e || "G" === e || "B" === e;
        });
    }

    function get_repeat_size(u32_comb_size, a_block_desc) {
        /* 同色灯连续次数，即几灯串 */
        var u32_clr_repeat_size = u32_comb_size - 1;

        for (; 0 < u32_clr_repeat_size; u32_clr_repeat_size--) {
            if (u32_comb_size % u32_clr_repeat_size) {
                continue;
            }
            var b_size_chk = true;

            for (var idx_rgb_offset = 0; idx_rgb_offset < u32_comb_size && b_size_chk; idx_rgb_offset += u32_clr_repeat_size) {
                var c_clr = a_block_desc[idx_rgb_offset];

                for (var idx_rgb = 1; idx_rgb < u32_clr_repeat_size && b_size_chk; idx_rgb++) {
                    if ("V" === c_clr) {
                        c_clr = a_block_desc[idx_rgb + idx_rgb_offset];
                        continue;
                    }

                    if (c_clr !== a_block_desc[idx_rgb + idx_rgb_offset]) {
                        b_size_chk = false;
                        break;
                    }
                }
            }

            if (b_size_chk) {
                break;
            }
        }
        return u32_clr_repeat_size;
    }
    function get_valid_color(u32_clr_cnt, u32_clr_repeat_size, a_block_desc) {
        var a_clr_ary = Array(u32_clr_cnt);

        for (var i = 0; i < a_clr_ary.length; i++) {
            a_clr_ary[i] = "V";
        }
        for (var idx_clr = 0; idx_clr < u32_clr_cnt; idx_clr++) {
            for (var idx_repeat = 0; idx_repeat < u32_clr_repeat_size; idx_repeat++) {
                var ui_key_pos = idx_clr * u32_clr_repeat_size + idx_repeat;

                if ("V" !== a_block_desc[ui_key_pos]) {
                    a_clr_ary[idx_clr] = a_block_desc[ui_key_pos];
                    break;
                }
            }
        }

        a_clr_ary.reverse();
        return a_clr_ary;
    }
    function get_led_combo_mode(obj_ret) {
        var u32_clr_list = ~0;

        if (obj_ret) {
            obj_ret.u32_clr_cnt = 0;
            obj_ret.u32_clr_repeat = 0;
            obj_ret.str_color = "";
        } else {
            return u32_clr_list;
        }

        if (0 === m_vst_str_ary.length || 0 === m_vst_str_ary[0].vst_scan_ary.length) {
            return u32_clr_list;
        }

        var m = "";
        var str_pix_clr_ary = get_pix_clr_ary();

        m = str_pix_clr_ary.match(/[^V]/g);

        if (!m) {
            return u32_clr_list;
        }

        /* 多灯串时，按多灯串时颜色像素混合占用的灯珠数 */
        var u32_comb_size = get_combo_size(str_pix_clr_ary);
        var ui_scan_len = str_pix_clr_ary.length;

        if (u32_comb_size < ui_scan_len) {
            /* 取尾部颜色数据 */
            str_pix_clr_ary = str_pix_clr_ary.slice(str_pix_clr_ary.length % u32_comb_size);

            /* 提取有效重复块，即排除V */
            var a_block_desc = Array(u32_comb_size);

            for (var i = 0; i < a_block_desc.length; i++) {
                a_block_desc[i] = "V";
            }
            var b_has_rgb = is_str_has_rgb(str_pix_clr_ary, u32_comb_size, a_block_desc);

            if (b_has_rgb) {
                /* 并行线 */
                if (1 === u32_comb_size) {
                    if (obj_ret) {
                        obj_ret.u32_clr_cnt = 1;
                        obj_ret.u32_clr_repeat = 1;
                        obj_ret.str_color = "R,G,B";
                    }
                } else if (1 < u32_comb_size) {
                    var u32_clr_repeat_size = get_repeat_size(u32_comb_size, a_block_desc);

                    if (0 < u32_clr_repeat_size) {
                        var u32_clr_cnt = u32_comb_size / u32_clr_repeat_size;

                        if (16 > u32_clr_cnt) {
                            if (obj_ret) {
                                obj_ret.u32_clr_cnt = u32_clr_cnt;
                                obj_ret.u32_clr_repeat = u32_clr_repeat_size;
                            }

                            /* 提取有效颜色，即排除V */
                            var a_clr_ary = get_valid_color(u32_clr_cnt, u32_clr_repeat_size, a_block_desc);

                            obj_ret.str_color = a_clr_ary.reverse().join();
                            u32_clr_list = ~0;
                            for (var idx_clr = 0; idx_clr < u32_clr_cnt; idx_clr++) {
                                var u32_mask = ~(3 << (idx_clr << 1));
                                var u32_valu = 3;

                                switch (a_clr_ary[idx_clr]) {
                                case "R": u32_valu = 0; break;
                                case "G": u32_valu = 1; break;
                                case "B": u32_valu = 2; break;
                                default: break;
                                }

                                u32_valu <<= idx_clr << 1;
                                u32_clr_list &= u32_mask;
                                u32_clr_list |= u32_valu;
                            }
                        } else {
                            if (obj_ret) {
                                obj_ret.u32_clr_cnt = 0;
                                obj_ret.u32_clr_repeat = 0;
                                obj_ret.str_color = "";
                            }
                        }
                    }
                }
            }
        }

        return u32_clr_list;
    }

    function get_str_color(ui_str_idx) {
        if (isNaN(parseInt(ui_str_idx, 10))) {
            return "N";
        }
        if (m_vst_str_ary.length <= ui_str_idx) {
            return "N";
        }
        if ("1" === m_st_mod_electrical.ui_str_grp_mode || 1 === m_st_mod_electrical.ui_str_grp_mode) {
            var obj_ret = {};

            get_led_combo_mode(obj_ret);
            return obj_ret.str_color;
        }
        var c_clr = "V";

        for (var idx_scan = 0; idx_scan < m_vst_str_ary[ui_str_idx].vst_scan_ary.length; idx_scan++) {
            var st_scan = m_vst_str_ary[ui_str_idx].vst_scan_ary[idx_scan];

            for (var idx_pix = 0; idx_pix < st_scan.vst_pix_ary.length; idx_pix++) {
                var st_pix = st_scan.vst_pix_ary[idx_pix];

                c_clr = st_pix.c_color;
                if ("V" === c_clr) {
                    c_clr = st_pix.c_color;
                } else {
                    if ("V" === st_pix.c_color) {
                        continue;
                    } else if (c_clr !== st_pix.c_color) {
                        return "N";
                    }
                }
            }
        }
        return c_clr;
    }

    function get_str_name(ui_str_idx) {
        if (isNaN(parseInt(ui_str_idx, 10))) {
            return "";
        }
        if (m_vst_str_ary.length <= ui_str_idx) {
            return "";
        }

        return m_vst_str_ary[ui_str_idx].str_str_name;
    }

    function set_str_name(u32_str_idx, ac_name) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return false;
        }
        if (MODULE_MAX_STR_CNT < u32_str_idx) {
            return false;
        }

        if (m_vst_str_ary.length <= u32_str_idx) {
            for (var i = 0; i < u32_str_idx + 1 - m_vst_str_ary.length; i++) {
                m_vst_str_ary.push(new mc_mod_str());
            }
        }

        if (!ac_name) {
            m_vst_str_ary[u32_str_idx].str_str_name = "";
            return false;
        }
        m_vst_str_ary[u32_str_idx].str_str_name = ac_name;
        return true;
    }

    function get_str_grp_mode() {
        return m_st_mod_electrical.ui_str_grp_mode;
    }

    function set_str_grp_mode(u32_grp_mode) {
        if (isNaN(parseInt(u32_grp_mode, 10))) {
            return false;
        }
        if (0 === u32_grp_mode) {
            return false;
        }
        m_st_mod_electrical.ui_str_grp_mode = Number(u32_grp_mode);
        return true;
    }

    function get_str_pin(ui_str_idx) {
        if (m_vst_str_ary.length <= ui_str_idx) {
            return "";
        }

        return m_vst_str_ary[ui_str_idx].str_pin_name;
    }

    function set_str_pin(u32_str_idx, ac_pin) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return false;
        }
        if (MODULE_MAX_STR_CNT < u32_str_idx) {
            return false;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            for (var i = 0; i < u32_str_idx + 1 - m_vst_str_ary.length; i++) {
                m_vst_str_ary.push(new mc_mod_str());
            }
        }

        if (!ac_pin) {
            m_vst_str_ary[u32_str_idx].str_pin_name = "";
            return false;
        }
        m_vst_str_ary[u32_str_idx].str_pin_name = ac_pin;
        return true;
    }
    function convert_vpix_by_img_coord(u32_max_img_x, u32_max_img_y) {
        if (isNaN(parseInt(u32_max_img_x, 10)) || isNaN(parseInt(u32_max_img_y, 10))) {
            return false;
        }
        var cla_vpix = new mc_mod_pix(0, 0, "V");

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < str.vst_scan_ary.length; idx_scan++) {
                var scan = str.vst_scan_ary[idx_scan];

                for (var idx_pix = 0; idx_pix < scan.vst_pix_ary.length; idx_pix++) {
                    var pix = scan.vst_pix_ary[idx_pix];

                    if (0 < u32_max_img_x && pix.u32_img_x > u32_max_img_x) {
                        scan.vst_pix_ary[idx_pix] = cla_vpix;
                        continue;
                    }

                    if (0 < u32_max_img_y && pix.u32_img_y > u32_max_img_y) {
                        scan.vst_pix_ary[idx_pix] = cla_vpix;
                        continue;
                    }
                }
            }
        }
        return true;
    }

    function set_pix_info(u32_str_idx, u32_scan_idx, u32_pix_idx, u32_img_x, u32_img_y, c_color) {
        if (isNaN(parseInt(u32_str_idx, 10)) || isNaN(parseInt(u32_scan_idx, 10)) || isNaN(parseInt(u32_pix_idx, 10))
            || isNaN(parseInt(u32_img_x, 10)) || isNaN(parseInt(u32_img_y, 10))) {
            return false;
        }
        if (MODULE_MAX_STR_CNT < u32_str_idx) {
            return false;
        }

        var i = 0;

        if (m_vst_str_ary.length <= u32_str_idx) {
            for (i = 0; i < u32_str_idx + 1 - m_vst_str_ary.length; i++) {
                m_vst_str_ary.push(new mc_mod_str());
            }
        }

        if (m_vst_str_ary[u32_str_idx].vst_scan_ary.length <= u32_scan_idx) {
            var scan_arr_len = m_vst_str_ary[u32_str_idx].vst_scan_ary.length;

            for (i = 0; i < u32_scan_idx + 1 - scan_arr_len; i++) {
                m_vst_str_ary[u32_str_idx].vst_scan_ary.push(new mc_mod_scan());
            }
        }

        if (m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary.length <= u32_pix_idx) {
            var pix_arr_len = m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary.length;

            for (i = 0; i < u32_pix_idx + 1 - pix_arr_len; i++) {
                m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary.push(new mc_mod_pix());
            }
        }

        m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary[u32_pix_idx].u32_img_x = Number(u32_img_x);
        m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary[u32_pix_idx].u32_img_y = Number(u32_img_y);
        m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary[u32_pix_idx].c_color = c_color;
        return true;
    }
    function get_pix_info(u32_str_idx, u32_scan_idx, u32_pix_idx) {
        var obj_ret = {};

        obj_ret.u32_img_x = 0;
        obj_ret.u32_img_y = 0;
        obj_ret.c_color = "V";

        if (m_vst_str_ary.length <= u32_str_idx ||
            m_vst_str_ary[u32_str_idx].vst_scan_ary.length <= u32_scan_idx ||
            m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary.length <= u32_pix_idx) {
            return obj_ret;
        }

        var st_pix = m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary[u32_pix_idx];

        obj_ret.u32_img_x = st_pix.u32_img_x;
        obj_ret.u32_img_y = st_pix.u32_img_y;
        obj_ret.c_color = st_pix.c_color;
        return obj_ret;
    }
    function erase_str_by_name(ac_str_name) {
        if (!ac_str_name) {
            return false;
        }

        ac_str_name = ac_str_name.toUpperCase();

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var str_str_name_exist = m_vst_str_ary[idx_str].str_str_name.toUpperCase();

            if (str_str_name_exist === ac_str_name) {
                m_vst_str_ary.splice(idx_str, 1);
                break;
            }
        }
        return true;
    }
    function erase_str_by_idx(u32_str_idx) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return false;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            return false;
        }
        m_vst_str_ary.splice(u32_str_idx, 1);
        return true;
    }
    function reset_str_pix(u32_str_idx) {
        if (isNaN(parseInt(u32_str_idx, 10))) {
            return false;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            return false;
        }
        m_vst_str_ary[u32_str_idx].vst_scan_ary = [];
        return true;
    }
    function reverse_scan_pix_order(u32_str_idx, u32_scan_idx) {
        if (m_vst_str_ary.length <= u32_str_idx || m_vst_str_ary[u32_str_idx].vst_scan_ary.length <= u32_scan_idx) {
            return false;
        }

        var vst_scan_pixs = m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary;

        m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary = vst_scan_pixs.reverse();
        return true;
    }
    function reset_scan_pix(u32_str_idx, u32_scan_idx) {
        if (isNaN(parseInt(u32_str_idx, 10) || isNaN(parseInt(u32_scan_idx, 10)))) {
            return false;
        }
        if (m_vst_str_ary.length <= u32_str_idx) {
            return false;
        }
        if (m_vst_str_ary[u32_str_idx].vst_scan_ary.length <= u32_scan_idx) {
            return false;
        }
        m_vst_str_ary[u32_str_idx].vst_scan_ary[u32_scan_idx].vst_pix_ary = [];
        return true;
    }
    function align_scan_len(u32_align_len) {
        if (isNaN(parseInt(u32_align_len, 10))) {
            return false;
        }

        var ui_align_len = u32_align_len;

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < st_str.vst_scan_ary.length; idx_scan++) {
                var st_scan = st_str.vst_scan_ary[idx_str];
                var ui_scan_len = st_scan.vst_pix_ary.length;

                if (ui_align_len > ui_scan_len) {
                    var arr_insert = Array(ui_align_len - ui_scan_len);

                    for (var idx_arr = 0; idx_arr < arr_insert.length; idx_arr++) {
                        arr_insert[idx_arr] = new mc_mod_pix(0, 0, "V");
                    }
                    for (var i = 0; i < arr_insert.length; i++) {
                        st_scan.vst_pix_ary.splice(i, 0, arr_insert[i]);
                    }
                } else {
                    st_scan.vst_pix_ary.length = ui_align_len;
                }
            }
        }
        return true;
    }
    function align_scan_cnt(u32_align_cnt) {
        if (isNaN(parseInt(u32_align_cnt, 10))) {
            return false;
        }
        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            if (u32_align_cnt < st_str.vst_scan_ary.length) {
                st_str.vst_scan_ary.length = u32_align_cnt;
            } else {
                for (var i = 0, len = u32_align_cnt - st_str.vst_scan_ary.length; i < len; i++) {
                    st_str.vst_scan_ary.push(new mc_mod_scan());
                }
            }
        }
        return true;
    }
    function combo_module(st_mod, u32_img_off_x, u32_img_off_y, b_add_data_far) {
        if (!(st_mod instanceof mc_sdk_module) || isNaN(parseInt(u32_img_off_x, 10) ||
            isNaN(parseInt(u32_img_off_y, 10)), isNaN(parseInt(u32_img_off_y, 10)))) {
            return false;
        }
        var st_pix = new mc_mod_pix(0, 0, "V");
        var ui_scan_len = get_max_scan_len();

        var a_mod_str_ary = st_mod.mc_util_mod_get_str_ary();

        if (m_vst_str_ary.length < a_mod_str_ary.length) {
            for (var idx_str_ary = 0; idx_str_ary < a_mod_str_ary.length - m_vst_str_ary.length; idx_str_ary++) {
                m_vst_str_ary.push(new mc_mod_str());
            }
        }

        var ui_str_cnt = m_vst_str_ary.length;
        var i = 0;

        for (var idx_str = 0; idx_str < ui_str_cnt; idx_str++) {
            if (a_mod_str_ary.length <= idx_str) {
                continue;
            }

            var st_str_src = a_mod_str_ary[idx_str];
            var st_str_dst = m_vst_str_ary[idx_str];

            if (st_str_src.vst_scan_ary.length > st_str_dst.vst_scan_ary.length) {
                for (var idx_scan_ary = 0; idx_scan_ary < st_str_src.vst_scan_ary.length - st_str_dst.vst_scan_ary.length; idx_scan_ary++) {
                    st_str_dst.vst_scan_ary.push(new mc_mod_scan());
                }
            }

            var ui_scan_cnt = st_str_dst.vst_scan_ary.length;

            for (var idx_scan = 0; idx_scan < ui_scan_cnt; idx_scan++) {
                if (st_str_src.vst_scan_ary.length <= idx_scan) {
                    continue;
                }

                var st_scan_src = st_str_src.vst_scan_ary[idx_scan];
                var st_scan_dst = st_str_dst.vst_scan_ary[idx_scan];

                /* pix align */
                if (st_scan_dst.vst_pix_ary.length < ui_scan_len) {
                    if (b_add_data_far) {
                        for (i = 0; i < ui_scan_len - st_scan_dst.vst_pix_ary.length; i++) {
                            st_scan_dst.vst_pix_ary.splice(i, 0, st_pix);
                        }
                    } else {
                        for (i = 0; i < ui_scan_len - st_scan_dst.vst_pix_ary.length; i++) {
                            st_scan_dst.vst_pix_ary.push(st_pix);
                        }
                    }
                }

                var idx_pix = 0;

                if (b_add_data_far) {
                    for (i = 0; i < st_scan_src.vst_pix_ary.length; i++) {
                        st_scan_dst.vst_pix_ary.splice(i, 0, st_scan_src.vst_pix_ary[i]);
                    }
                    for (idx_pix = 0; idx_pix < st_scan_src.vst_pix_ary.length; idx_pix++) {
                        st_scan_dst.vst_pix_ary[idx_pix].u32_img_x += u32_img_off_x;
                        st_scan_dst.vst_pix_ary[idx_pix].u32_img_y += u32_img_off_y;
                    }
                } else {
                    var ui_ori_size = st_scan_dst.vst_pix_ary.length;

                    st_scan_dst.vst_pix_ary = st_scan_dst.vst_pix_ary.concat(st_scan_src.vst_pix_ary);
                    for (idx_pix = 0; idx_pix < st_scan_src.vst_pix_ary.length; idx_pix++) {
                        st_scan_dst.vst_pix_ary[ui_ori_size + idx_pix].u32_img_x += u32_img_off_x;
                        st_scan_dst.vst_pix_ary[ui_ori_size + idx_pix].u32_img_y += u32_img_off_y;
                    }
                }
            }
        }
        return true;
    }

    function sort_scan_pix_by_step(u32_step, u32_cell_len) {
        if (isNaN(parseInt(u32_step, 10)) || isNaN(parseInt(u32_cell_len, 10))) {
            return false;
        }
        if (2 > u32_step) {
            return false;
        }

        if (0 === u32_cell_len) {
            u32_cell_len = 1;
        }

        // var st_pix = new mc_mod_pix(0, 0, "V");

        var u32_scan_len = get_max_scan_len();

        u32_scan_len = ((u32_scan_len - 1) / (u32_step * u32_cell_len) + 1) * u32_step * u32_cell_len;

        align_scan_len(u32_scan_len);

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < st_str.vst_scan_ary.length; idx_scan++) {
                var st_scan = st_str.vst_scan_ary[idx_scan];
                var u32_res_size = st_scan.vst_pix_ary.length;
                var vst_pix_tmp = st_scan.vst_pix_ary;

                st_scan.vst_pix_ary = [];

                var u32_cell_cnt = u32_res_size / u32_step / u32_cell_len;

                for (var idx_step = 0; idx_step < u32_step; idx_step++) {
                    for (var idx_cell = 0; idx_cell < u32_cell_cnt; idx_cell++) {
                        for (var idx_item = 0; idx_item < u32_cell_len; idx_item++) {
                            st_scan.vst_pix_ary.push(vst_pix_tmp[(idx_step + idx_cell * u32_step) * u32_cell_len + idx_item]);
                        }
                    }
                }
            }
        }
        return true;
    }
    function add_offset(i32_x_offset, i32_y_offset) {
        if (isNaN(parseInt(i32_x_offset, 10)) || isNaN(parseInt(i32_y_offset, 10))) {
            return false;
        }
        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var st_str = m_vst_str_ary[idx_str];

            for (var idx_scan = 0; idx_scan < st_str.vst_scan_ary.length; idx_scan++) {
                var st_scan = st_str.vst_scan_ary[idx_scan];

                for (var idx_pix = 0; idx_pix < st_scan.vst_pix_ary.length; idx_pix++) {
                    var st_pix = st_scan.vst_pix_ary[idx_pix];

                    if (0 > i32_x_offset && st_pix.u32_img_x < -i32_x_offset) {
                        st_pix.u32_img_x = Number.MAX_VALUE;
                    } else {
                        st_pix.u32_img_x += i32_x_offset;
                    }

                    if (0 > i32_y_offset && st_pix.u32_img_y < -i32_y_offset) {
                        st_pix.u32_img_y = Number.MAX_VALUE;
                    } else {
                        st_pix.u32_img_y += i32_y_offset;
                    }
                }
            }
        }
        return true;
    }

    function get_str_scan_pix_cnt() {
        var ui_grp_mode = get_str_grp_mode();

        ui_grp_mode = parseInt(ui_grp_mode, 10);

        if (1 !== ui_grp_mode) {
            return false;
        }
        var ary_pix_val = m_vst_str_ary;

        ary_pix_val = ary_pix_val[0].vst_scan_ary;

        if (0 === ary_pix_val.length) {
            return 0;
        }
        ary_pix_val = ary_pix_val[0].vst_pix_ary;

        var ui_scan_pix_cnt = 0;
        var str_color = "";

        for (var idx_pix = 0; idx_pix < ary_pix_val.length; idx_pix++) {
            if (str_color !== ary_pix_val[idx_pix].c_color && 0 !== idx_pix) {
                break;
            }
            str_color = ary_pix_val[idx_pix].c_color;
            ui_scan_pix_cnt++;
        }
        return ui_scan_pix_cnt;
    }


    /********** Xsc *********************************************************************************/

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置模组行扫数量(为记录值与描点信息无关联)
    * 参数:
         @param { Promise<Number> } ui_scan_cnt 行扫数
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.25
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_scan_cnt(ui_scan_cnt) {
        if ("number" !== typeof ui_scan_cnt || isNaN(ui_scan_cnt)) {
            return false;
        }
        m_st_mod_electrical.ui_scan_cnt = ui_scan_cnt;
        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置串行类型
    * 参数:
         @param { Promise<Number> } ui_led_type 串行类型
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.25
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_led_type(ui_led_type) {
        if ("number" !== typeof ui_led_type || isNaN(ui_led_type)) {
            return false;
        }
        m_st_mod_electrical.ui_led_type = ui_led_type;
        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置颜色信息
    * 参数:
         @param { Promise<Number> } ary_clr_msg 颜色信息
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.25
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_clr_msg(ary_clr_msg) {
        if (!Array.isArray(ary_clr_msg) || 0 >= ary_clr_msg.length) {
            return false;
        }
        m_st_mod_electrical.ary_clr_msg = ary_clr_msg;
        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置显示芯片注册信息jump_ic
    * 参数:
         @param { Promise<String> } str_jump_ic jump_ic
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.25
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_dispchip_info_jump_ic(str_jump_ic) {
        if ("string" !== typeof str_jump_ic || 0 >= str_jump_ic.length) {
            return false;
        }
        m_st_mod_dispchip_info.str_jump_ic = str_jump_ic;
        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置显示芯片注册信息ic_channels数
    * 参数:
         @param { Promise<String> } str_ic_channels ic_channels
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.25
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_dispchip_info_ic_channels(str_ic_channels) {
        if ("string" !== typeof str_ic_channels || 0 >= str_ic_channels.length) {
            return false;
        }
        m_st_mod_dispchip_info.str_ic_channels = str_ic_channels;
        return true;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    复制当前信息产生新的数据对象
    * 参数:
         @param {Promise<Object>} obj_copy_module mc_sdk_module实例对象
    * 返回：
    *    @return { Promise<Object>} 复制对象
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.9.29
    *      内容 : 所有代码
    ************************************************************************************************/
    function copy_msg(obj_copy_module) {
        if ("function" !== typeof obj_copy_module.mc_util_mod_reset) {
            return false;
        }
        obj_copy_module.mc_util_mod_reset();
        obj_copy_module.mc_util_mod_set_led_name(m_st_mod_apperance.str_led_name);
        obj_copy_module.mc_util_mod_set_pitch(m_st_mod_apperance.d_pitch);
        obj_copy_module.mc_util_mod_set_width(m_st_mod_apperance.ui_width);
        obj_copy_module.mc_util_mod_set_height(m_st_mod_apperance.ui_height);
        obj_copy_module.mc_util_mod_set_disp_chip(m_st_mod_electrical.str_disp_chip);
        obj_copy_module.mc_util_mod_set_scan_chip(m_st_mod_electrical.str_scan_chip);
        obj_copy_module.mc_util_mod_set_scan_pix_step(m_st_mod_electrical.ui_str_pix_step);
        obj_copy_module.mc_util_mod_set_str_grp_mode(m_st_mod_electrical.ui_str_grp_mode);
        obj_copy_module.mc_util_mod_set_max_frequence(m_st_mod_electrical.df_max_frq);
        obj_copy_module.mc_util_mod_set_oe_low_valid(m_st_mod_electrical.b_oe_low_valid);
        obj_copy_module.mc_util_mod_set_close_low_valid(m_st_mod_electrical.b_close_low_valid);
        obj_copy_module.mc_util_mod_set_tx_low_valid(m_st_mod_electrical.b_tx_low_valid);
        obj_copy_module.mc_util_mod_set_led_type(m_st_mod_electrical.ui_led_type);
        obj_copy_module.mc_util_mod_set_scan_cnt(m_st_mod_electrical.ui_scan_cnt);
        obj_copy_module.mc_util_mod_set_clr_msg(m_st_mod_electrical.ary_clr_msg);
        obj_copy_module.mc_util_mod_set_jump_ic(m_st_mod_dispchip_info.str_jump_ic);
        obj_copy_module.mc_util_mod_set_ic_channels(m_st_mod_dispchip_info.str_ic_channels);

        var ary_sclk_data = m_st_mod_electrical.vstr_sclk_pin_ary;

        for (var idx_clk = 0; idx_clk < ary_sclk_data.length; idx_clk++) {
            obj_copy_module.mc_util_mod_set_sclk_pin_name(idx_clk,ary_sclk_data[idx_clk]);
        }

        for (var idx_str = 0; idx_str < m_vst_str_ary.length; idx_str++) {
            var obj_str_data = m_vst_str_ary[idx_str];
            var ary_scan_data = obj_str_data.vst_scan_ary;

            obj_copy_module.mc_util_mod_set_str_name(idx_str,obj_str_data.str_str_name);
            obj_copy_module.mc_util_mod_set_str_pin(idx_str,obj_str_data.str_pin_name);

            for (var idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                var ary_pix_data = ary_scan_data[idx_scan].vst_pix_ary;

                for (var idx_pix = 0; idx_pix < ary_pix_data.length; idx_pix++) {
                    var obj_pix_data = ary_pix_data[idx_pix];

                    obj_copy_module.mc_util_mod_set_pix_info(
                        idx_str,
                        idx_scan,
                        idx_pix,
                        obj_pix_data.u32_img_x,
                        obj_pix_data.u32_img_y,
                        obj_pix_data.c_color
                    );
                }
            }
        }

        return true;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    更新模组描点信息为建议模组描点信息
    * 参数:
    *    @param {Promise<Number>} ui_mod_max_w 模组最大宽度
    *    @param {Promise<Number>} ui_mod_max_h 模组最大高度度
    * 返回：
    *    @returns {Promise<Number>} 更新结果
    * 备注:
    *   0:成功
    *   1:未知错误
    *   2:简易模组条件错误(长或宽等于单扫长度)
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.11.13
    *      内容 : 所有代码
    ************************************************************************************************/
    function updata_mod_size(ui_mod_max_w,ui_mod_max_h) {
        // 分组模式
        var ui_grp_mod = Number(get_str_grp_mode());
        // 串行类型
        var ui_serial_type = Number(m_st_mod_electrical.ui_led_type);
        var ui_sclk_cnt = m_st_mod_electrical.vstr_sclk_pin_ary.length;
        var ui_led_cnt = ui_serial_type * ui_sclk_cnt;
        var ui_grp_cnt = Number(get_str_cnt()) / ui_grp_mod;
        var ui_scan_cnt = m_st_mod_electrical.ui_scan_cnt;

        // 出现异常参数
        if ( 0 !== ui_grp_cnt % 1) {
            return 1;
        }
        // 简易模组条件:长或宽为数据组数*单扫长度
        if (
            ui_mod_max_w !== ui_grp_cnt * ui_scan_cnt &&
            ui_mod_max_h !== ui_grp_cnt * ui_scan_cnt
        ) {
            return 2;
        }
        m_st_mod_apperance.ui_width = ui_mod_max_w;
        m_st_mod_apperance.ui_height = ui_mod_max_h;
        m_vst_str_ary = [];
        var ary_mod_clr = m_st_mod_electrical.ary_clr_msg;
        var ary_return_data = [];
        var idx_h = 0;
        var idx_w = 0;
        var obj_dot = {};
        var idx_grp = 0;
        var ui_grp_idx = 0;
        var idx_grp_mod = 0;
        var ui_grp_len = ary_mod_clr.length;

        if (ui_mod_max_h === ui_grp_cnt * ui_scan_cnt) {
            ui_mod_max_h = ui_scan_cnt;
            for (idx_grp = 0; idx_grp < ui_grp_cnt; idx_grp++) {
                ui_grp_idx = idx_grp * ui_grp_len;

                for (idx_grp_mod = 0; idx_grp_mod < ui_grp_len; idx_grp_mod++) {
                    if (!ary_return_data[ui_grp_idx + idx_grp_mod]) {
                        ary_return_data[ui_grp_idx + idx_grp_mod] = [];
                    }
                    for (idx_h = 0; idx_h < ui_mod_max_h; idx_h++) {
                        for (idx_w = ui_mod_max_w; 0 < idx_w; idx_w--) {
                            obj_dot = {
                                x: idx_w,
                                y: ((idx_h + 1) + (idx_grp * ui_scan_cnt)),
                                invalid_cnt: 0,
                                color: ary_mod_clr[(ui_grp_idx + idx_grp_mod) % ui_grp_len]
                            };
                            if (!ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt]) {
                                ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt] = [obj_dot];
                            } else {
                                ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt].push(obj_dot);
                            }
                        }
                    }
                }
            }
        } else {
            ui_mod_max_w = ui_scan_cnt;
            for (idx_grp = 0; idx_grp < ui_grp_cnt; idx_grp++) {
                ui_grp_idx = idx_grp * ui_grp_len;

                for (idx_grp_mod = 0; idx_grp_mod < ui_grp_len; idx_grp_mod++) {
                    if (!Array.isArray(ary_return_data[ui_grp_idx + idx_grp_mod])) {
                        ary_return_data[ui_grp_idx + idx_grp_mod] = [];
                    }
                    for (idx_w = 0; idx_w < ui_mod_max_w; idx_w++) {
                        for (idx_h = ui_mod_max_h; 0 < idx_h; idx_h--) {
                            obj_dot = {
                                x: ((idx_w + 1) + (idx_grp * ui_scan_cnt)),
                                y: idx_h,
                                invalid_cnt: 0,
                                color: ary_mod_clr[(ui_grp_idx + idx_grp_mod) % ui_grp_len]
                            };
                            if (!Array.isArray(ary_return_data[ui_grp_idx + idx_grp_mod][(idx_h % ui_scan_cnt)])) {
                                ary_return_data[ui_grp_idx + idx_grp_mod][(idx_h % ui_scan_cnt)] = [obj_dot];
                            } else {
                                ary_return_data[ui_grp_idx + idx_grp_mod][(idx_h % ui_scan_cnt)].push(obj_dot);
                            }
                        }
                    }
                }
            }
        }

        if (1 === ui_grp_mod) {
            ary_return_data = merge_ary_by_led_cnt(ui_grp_len, ui_led_cnt,ui_grp_cnt, ary_return_data);
        }

        set_assign_str_ary(ary_return_data);

        return 0;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    根据灯珠数排序走点信息
    * 参数:
    *    @param {Promise<Number>} ui_clr_cnt 颜色数量
    *    @param {Promise<Number>} ui_led_cnt 灯珠数
    *    @param {Promise<Number>} ui_grp_cnt 数据组数
    *    @param {Promise<Number>} ary_end_data 排序数组
    * 返回：
    *    @returns {Promise<Boolean>} 更新结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.11.13
    *      内容 : 所有代码
    ************************************************************************************************/
    function merge_ary_by_led_cnt(ui_clr_cnt, ui_led_cnt,ui_grp_cnt, ary_end_data) {
        var ary_return = [];

        // 循环数据组数,区分N条线
        for (var idx_str = 0; idx_str < ui_grp_cnt; idx_str++) {
            var ui_str_idx = idx_str * ui_clr_cnt;
            var ui_str_len = ary_end_data[0].length;

            ary_return.push([]);
            // 循环单条线长度(因为所有线必须对齐,所以可以直接根据单线长度来进行排序)
            for (var idx_scan = 0; idx_scan < ui_str_len; idx_scan++) {
                var ary_scan_data = ary_end_data[idx_str * ui_clr_cnt][idx_scan];

                for (var idx_pix = 0; idx_pix < ary_scan_data.length; idx_pix += ui_led_cnt) {
                // 根据灯珠数获取每条线上的X个点,以X个点为一组进行排序
                    for (var idx_led_len = 0; idx_led_len < ui_clr_cnt; idx_led_len++) {
                        // 取排序数据X个点来排序
                        for (var idx_led_cnt = 0; idx_led_cnt < ui_led_cnt; idx_led_cnt++) {
                            var obj_point_data = ary_end_data[ui_str_idx + idx_led_len][idx_scan][idx_pix + idx_led_cnt];

                            if (!Array.isArray(ary_return[idx_str][idx_scan])) {
                                ary_return[idx_str][idx_scan] = [];
                            }
                            if (!obj_point_data) {
                                ary_return[idx_str][idx_scan].push(null);
                                continue;
                            }
                            ary_return[idx_str][idx_scan].push(obj_point_data);
                        }
                    }
                }
            }
        }

        return ary_return;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    存入描点信息
    * 参数:
    *    @param {Promise<Number>} ary_return_data 存入数组
    * 返回：
    *    NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.11.13
    *      内容 : 所有代码
    ************************************************************************************************/
    function set_assign_str_ary(ary_return_data) {
        for (var idx_str = 0; idx_str < ary_return_data.length; idx_str++) {
            m_vst_str_ary.push(new mc_mod_str());
            m_vst_str_ary[idx_str].str_pin_name = "STR_" + idx_str;
            m_vst_str_ary[idx_str].str_str_name = "STR_" + idx_str;

            var ary_scan_data = ary_return_data[idx_str];

            for (var idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                m_vst_str_ary[idx_str].vst_scan_ary.push(new mc_mod_scan());

                var ary_led_data = ary_scan_data[idx_scan];

                for (var idx_led = (ary_led_data.length - 1); 0 <= idx_led; idx_led--) {
                    var obj_led_data = ary_led_data[idx_led];
                    var ui_img_x = 0;
                    var ui_img_y = 0;
                    var str_c_clr = "V";

                    m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary.push(new mc_mod_pix());
                    if (obj_led_data) {
                        ui_img_x = obj_led_data.x - 1;
                        ui_img_y = obj_led_data.y - 1;
                        str_c_clr = obj_led_data.color;
                    }
                    m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary[(ary_led_data.length - (idx_led + 1))].u32_img_x = ui_img_x;
                    m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary[(ary_led_data.length - (idx_led + 1))].u32_img_y = ui_img_y;
                    m_vst_str_ary[idx_str].vst_scan_ary[idx_scan].vst_pix_ary[(ary_led_data.length - (idx_led + 1))].c_color = str_c_clr;
                }
            }
        }
    }
    /********** EXPORT API *********************************************************************************/

    /**
     * @param {promises<String>} ac_led_name 需要设置的 APPERANCE 标签的 LED_NAME 属性
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_led_name = function (ac_led_name) {
        return set_led_name(ac_led_name);
    };

    /**
     * @returns {promises<String>}  APPERANCE 标签的 LED_NAME 属性
     **/
    this.mc_util_mod_get_led_name = function () {
        return get_led_name();
    };

    /**
     * @param {promises<Double>} d_pitch 需要设置的 APPERANCE 标签的 PITCH 属性
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_pitch = function (d_pitch) {
        return set_pitch(d_pitch);
    };

    /**
     * @returns {promises<Double>}  APPERANCE 标签的 PITCH 属性
     **/
    this.mc_util_mod_get_pitch = function () {
        return get_pitch();
    };

    /**
     * @param {promises<UInt>} ui_width 需要设置的 APPERANCE 标签的 WIDTH 属性
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_width = function (ui_width) {
        return set_width(ui_width);
    };

    /**
     * @returns {promises<UInt>}  APPERANCE 标签的 WIDTH 属性
     **/
    this.mc_util_mod_get_width = function () {
        return get_width();
    };

    /**
     * @param {promises<UInt>} ui_height 需要设置的 APPERANCE 标签的 HEIGHT 属性
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_height = function (ui_height) {
        return set_height(ui_height);
    };

    /**
     * @returns {promises<UInt>}  APPERANCE 标签的 HEIGHT 属性
     **/
    this.mc_util_mod_get_height = function () {
        return get_height();
    };

    /**
     * @param {promises<String>} ac_chip_name 显示芯片名称
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_disp_chip = function (ac_chip_name) {
        return set_disp_chip(ac_chip_name);
    };

    /**
     * @returns {promises<String>}  显示芯片名称
     **/
    this.mc_util_mod_get_disp_chip = function () {
        return get_disp_chip();
    };
    /**
     * @param {promises<String>} ac_chip_name 行管芯片名称
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_scan_chip = function (ac_chip_name) {
        return set_scan_chip(ac_chip_name);
    };
    /**
     * @returns {promises<String>}  行管芯片名称
     **/
    this.mc_util_mod_get_scan_chip = function () {
        return get_scan_chip();
    };
    /**
     * @param {promises<Uint>}  ui_step 步长
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_scan_pix_step = function (ui_step) {
        return set_scan_pix_step(ui_step);
    };
    /**
     * @returns {promises<String>}  pix步长
     **/
    this.mc_util_mod_get_scan_pix_step = function () {
        return get_scan_pix_step();
    };
    /**
     * @returns {promises<String>}  SCLK长度
     **/
    this.mc_util_mod_get_sclk_pin_cnt = function () {
        return get_sclk_pin_cnt();
    };
    /**
     * 设置指定索引的SCLK名称
     * @param {promises<Uint>}  ui_idx 下标索引
     * @param {promises<Uint>}  ac_pin_name SCLK名称
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_sclk_pin_name = function (ui_idx, ac_pin_name) {
        return set_sclk_pin_name(ui_idx, ac_pin_name);
    };
    /**
     * 设置指定索引的SCLK名称
     * @param {promises<Uint>}  ui_idx 下标索引
     * @returns {promises<String>}  SCLK名称
     **/
    this.mc_util_mod_get_sclk_pin_name = function (ui_idx) {
        return get_sclk_pin_name(ui_idx);
    };
    /**
     * 设置最大频率
     * @param {promises<Double>}  df_max_frq 最大频率
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_max_frequence = function (df_max_frq) {
        return set_max_frequence(df_max_frq);
    };
    /**
     * 获取最大频率
     * @returns {promises<boolean>} 最大频率
     **/
    this.mc_util_mod_get_max_frequence = function () {
        return get_max_frequence();
    };
    /**
     * @param {promises<boolean>} b_low_valid 有效值
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_oe_low_valid = function (b_low_valid) {
        return set_oe_low_valid(b_low_valid);
    };
    /**
     * @returns {promises<boolean>} 是否OE低有效
     **/
    this.mc_util_mod_get_oe_low_valid = function () {
        return get_oe_low_valid();
    };
    /**
     * @param {promises<boolean>} b_low_valid 有效值
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_close_low_valid = function (b_low_valid) {
        return set_close_low_valid(b_low_valid);
    };
    /**
     * @returns {promises<boolean>} 是否OE放电极性低有效
     **/
    this.mc_util_mod_get_close_low_valid = function () {
        return get_close_low_valid();
    };
    /**
     * @param {promises<boolean>} b_low_valid 有效值
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_tx_low_valid = function (b_low_valid) {
        return set_tx_low_valid(b_low_valid);
    };
    /**
     * @returns {promises<String>} 是否tx低有效
     **/
    this.mc_util_mod_get_tx_low_valid = function () {
        return get_tx_low_valid();
    };
    /**
     * @param {promises<boolean>} ui_scan_sta_pos 起始扫数
     * @param {promises<boolean>} ui_scan_end_pos 结束扫数
     * @returns {promises<{u32_left: Uint, u32_top: Uint, u32_right: Uint, u32_bottom: Uint}>}
     **/
    this.mc_util_mod_get_img_rect = function (ui_scan_sta_pos, ui_scan_end_pos) {
        return get_img_rect(ui_scan_sta_pos, ui_scan_end_pos);
    };
    /**
     * @returns {promises<Uint>} str个数
     **/
    this.mc_util_mod_get_str_cnt = function () {
        return get_str_cnt();
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<Uint>} 最大行长
     **/
    this.mc_util_mod_get_str_max_scan_len = function (ui_str_idx) {
        return get_str_max_scan_len(ui_str_idx);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<Uint>} str扫数
     **/
    this.mc_util_mod_get_scan_cnt = function (ui_str_idx) {
        return get_scan_cnt(ui_str_idx);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<Uint>} ui_scan_idx 扫数索引
     * @returns {promises<Uint>} pix个数
     **/
    this.mc_util_mod_get_pix_cnt = function (ui_str_idx, ui_scan_idx) {
        return get_pix_cnt(ui_str_idx, ui_scan_idx);
    };
    /**
     * @returns {promises<Uint>} 最大扫描数
     **/
    this.mc_util_mod_get_max_scan_cnt = function () {
        return get_max_scan_cnt();
    };
    /**
     * @returns {promises<Uint>} 最大扫描长度
     **/
    this.mc_util_mod_get_max_scan_len = function () {
        return get_max_scan_len();
    };
    /**
     * 合并模式
     * @param {promises<{u32_clr_cnt: Number, u32_clr_repeat: Number, str_color: String}>} obj_ret
     * 串行下 RRGGBB， u32_clr_cnt=u32_clr_repeat=2, str_color=R,G,B
     * @returns {promises<Uint>} u32_clr_list 位模式表示的颜色，RGB为0b000110
     **/
    this.mc_util_mod_get_led_comb_mode = function (obj_ret) {
        return get_led_combo_mode(obj_ret);
    };
    /**
     * 扫描数对齐
     * @param {promises<Uint>} ui_scan_cnt 对齐数
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_align_scan_cnt = function (ui_scan_cnt) {
        return align_scan_cnt(ui_scan_cnt);
    };
    /**
     * 扫描数长度对齐
     * @param {promises<Uint>} ui_scan_len 对齐数, pix个数
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_align_scan_len = function (ui_scan_len) {
        return align_scan_len(ui_scan_len);
    };
    /**
     * @returns {promises<Array>} PIX_STRS数据
     **/
    this.mc_util_mod_get_str_ary = function () {
        return m_vst_str_ary;
    };
    /**
     * @returns {promises<Object>} ELECTRICAL数据
     **/
    this.mc_util_mod_get_electrica = function () {
        return m_st_mod_electrical;
    };
    /**
     * @param {promises<Object>} h_mod_src 原模组
     * @param {promises<Uint>} ui_img_off_x x坐标
     * @param {promises<Uint>} ui_img_off_y y坐标
     * @param {promises<Uint>} uc_add_data_far
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_combo_module = function (h_mod_src, ui_img_off_x, ui_img_off_y, uc_add_data_far) {
        return combo_module(h_mod_src, ui_img_off_x, ui_img_off_y, 0 !== uc_add_data_far);
    };
    /**
     * @param {promises<Uint>} ui_step
     * @param {promises<Uint>} ui_cell_len
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_sort_scan_pix_by_step = function (ui_step, ui_cell_len) {
        return sort_scan_pix_by_step(ui_step, ui_cell_len);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<String>} 颜色
     **/
    this.mc_util_mod_get_str_color = function (ui_str_idx) {
        return get_str_color(ui_str_idx);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<String>} str名称
     **/
    this.mc_util_mod_get_str_name = function (ui_str_idx) {
        return get_str_name(ui_str_idx);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<String>} ac_name 名称
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_str_name = function (ui_str_idx, ac_name) {
        return set_str_name(ui_str_idx, ac_name);
    };
    /**
     * @returns {promises<String>} str分组模式
     **/
    this.mc_util_mod_get_str_grp_mode = function () {
        return get_str_grp_mode();
    };
    /**
     * @param {promises<Uint>} ui_grp_mode 分组模式
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_str_grp_mode = function (ui_grp_mode) {
        return set_str_grp_mode(ui_grp_mode);
    };
    /**
     * @returns {promises<String>} 灯串株数
     **/
    this.mc_util_mod_get_str_scan_pix_cnt = function () {
        return get_str_scan_pix_cnt();
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<String>} str PIN
     **/
    this.mc_util_mod_get_str_pin = function (ui_str_idx) {
        return get_str_pin(ui_str_idx);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<String>} ac_pin STR pin
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_str_pin = function (ui_str_idx, ac_pin) {
        return set_str_pin(ui_str_idx, ac_pin);
    };
    this.mc_util_mod_convert_vpix_by_img_coord = function (ui_max_img_x, ui_max_img_y) {
        return convert_vpix_by_img_coord(ui_max_img_x, ui_max_img_y);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<Uint>} ui_scan_idx 行扫
     * @param {promises<Uint>} ui_pix_idx pix下标索引
     * @param {promises<Uint>} ui_img_x x坐标
     * @param {promises<Uint>} ui_img_y y坐标
     * @param {promises<String>} c_clr 颜色
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_pix_info = function (ui_str_idx, ui_scan_idx, ui_pix_idx,
        ui_img_x, ui_img_y, c_clr) {
        return set_pix_info(ui_str_idx, ui_scan_idx, ui_pix_idx, ui_img_x, ui_img_y, c_clr);
    };
    /**
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<Uint>} ui_scan_idx 行扫
     * @param {promises<Uint>} ui_pix_idx pix下标索引
     * @returns {promises<{u32_img_x: Uint, u32_img_y: Uint, c_color: char}>} pix info
     **/
    this.mc_util_mod_get_pix_info = function (ui_str_idx, ui_scan_idx, ui_pix_idx) {
        return get_pix_info(ui_str_idx, ui_scan_idx, ui_pix_idx);
    };
    /**
     * 清空str数据
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_reset_str_pix = function (ui_str_idx) {
        return reset_str_pix(ui_str_idx);
    };
    /**
     * 反序各行扫下pix
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_reverse_scan_pix_order = function () {
        var u32_str_cnt = get_str_cnt();

        for (var idx_str = 0; idx_str < u32_str_cnt; idx_str++) {
            var u32_row_cnt = get_scan_cnt(idx_str);

            for (var idx_row = 0; idx_row < u32_row_cnt; idx_row++) {
                reverse_scan_pix_order(idx_str, idx_row);
            }
        }
        return true;
    };
    /**
     * 清空str的指定行扫数据
     * @param {promises<Uint>} ui_str_idx str下标索引
     * @param {promises<Uint>} ui_scan_idx 行扫
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_reset_scan_pix = function (ui_str_idx, ui_scan_idx) {
        return reset_scan_pix(ui_str_idx, ui_scan_idx);
    };
    /**
     * 删除指定名称的str
     * @param {promises<String>} ac_str_name str名称
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_erase_str_by_name = function (ac_str_name) {
        return erase_str_by_name(ac_str_name);
    };
    /**
     * 删除指定下标索引的str
     * @param {promises<String>} ui_str_idx str下标索引
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_erase_str_by_idx = function (ui_str_idx) {
        return erase_str_by_idx(ui_str_idx);
    };
    /**
     * 测试是否相等
     * @param {promises<Object>} h_mod_2_xml 测试对象子串
     * @returns {promises<boolean>} 比较结果
     **/
    this.mc_util_mod_check_equal = function (h_mod_2_xml) {
        return equals(h_mod_2_xml);
    };
    /**
     * 解析xml字符串, 设置到对象中
     * @param {promises<String>} ac_xml_data xml数据
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_xml = function (ac_xml_data) {
        return set_xml_data(ac_xml_data);
    };
    /**
     * @param {promises<Object>} h_mod_src 源数据
     * @param {promises<Uint>} ui_scan_sta_pos 起始行扫
     * @param {promises<Uint>} ui_scan_end_pos 结束行行扫
     * @returns {promises<boolean>} 操作结果
     **/
    this.mc_util_mod_set_mod = function (h_mod_src, ui_scan_sta_pos, ui_scan_end_pos) {
        return set_mod(h_mod_src, ui_scan_sta_pos, ui_scan_end_pos);
    };
    /**
     * 偏移各pix
     * @param {promises<Uint>} i_x_offset x偏移量
     * @param {promises<Uint>} i_y_offset y偏移量
     * @returns {promises<Uint>} 操作结果
     **/
    this.mc_util_mod_add_offset = function (i_x_offset, i_y_offset) {
        if (0 === i_x_offset && 0 === i_y_offset) {
            return true;
        }
        add_offset(i_x_offset, i_y_offset);
        return true;
    };
    /**
     * 清空数据
     * @returns {promises<Uint>} 操作结果
     **/
    this.mc_util_mod_reset = function () {
        return reset();
    };
    /**
     * 获取xml格式字符串
     * @returns {promises<String>} 操作结果
     **/
    this.mc_util_mod_get_xml = function () {
        return get_xml_data();
    };

    /* ******************************** Xsc ********************************************* */
    /**
     * 设置行扫数(仅记录设置行扫数,与描点信息无直接关联)
     * @param {Promise<Number>} ui_scan_cnt 行扫数
     * @returns {Promise<Boolean>} 设置结果
    */
    this.mc_util_mod_set_scan_cnt = function (ui_scan_cnt) {
        return set_scan_cnt(ui_scan_cnt);
    };
    /**
     * 获取设置行扫数
     * @returns {Promise<Number>} 行扫数
    */
    this.mc_util_mod_get_scan_cnt_loc = function () {
        return m_st_mod_electrical.ui_scan_cnt;
    };
    /**
     * 设置串行类型
     * @param {Promise<Number>} ui_led_type 串行类型
     * @returns {Promise<Boolean>} 设置结果
    */
    this.mc_util_mod_set_led_type = function (ui_led_type) {
        return set_led_type(ui_led_type);
    };
    /**
     * 获取设置串行类型
     * @returns {Promise<Number>} 串行类型
    */
    this.mc_util_mod_get_led_type = function () {
        return m_st_mod_electrical.ui_led_type;
    };
    /**
     * 设置颜色信息
     * @param {Promise<Array>} ary_clr_msg 颜色信息
     * @returns {Promise<Boolean>} 设置结果
    */
    this.mc_util_mod_set_clr_msg = function (ary_clr_msg) {
        return set_clr_msg(ary_clr_msg);
    };
    /**
     * 获取颜色信息
     * @returns {Promise<Number>} 颜色信息
    */
    this.mc_util_mod_get_clr_msg = function () {
        return m_st_mod_electrical.ary_clr_msg;
    };
    /**
     * 设置显示芯片注册信息jump_ic
     * @param {Promise<String>} str_jump_ic jump_ic
     * @returns {Promise<Boolean>} 设置结果
    */
    this.mc_util_mod_set_jump_ic = function (str_jump_ic) {
        return set_dispchip_info_jump_ic(str_jump_ic);
    };
    /**
     * 获取显示芯片注册信息jump_ic
     * @returns {Promise<String>} jump_ic
    */
    this.mc_util_mod_get_jump_ic = function () {
        return m_st_mod_dispchip_info.str_jump_ic;
    };

    /**
     * 设置显示芯片注册信息ic_channels
     * @param {Promise<String>} str_ic_channels ic_channels
     * @returns {Promise<Boolean>} 设置结果
    */
    this.mc_util_mod_set_ic_channels = function (str_ic_channels) {
        return set_dispchip_info_ic_channels(str_ic_channels);
    };
    /**
     * 获取显示芯片注册信息ic_channels
     * @returns {Promise<String>} ic_channels
    */
    this.mc_util_mod_get_ic_channels = function () {
        return m_st_mod_dispchip_info.str_ic_channels;
    };
    /**
     * 复制数据对象
     * @param {Promise<Object>} obj_copy_module mc_sdk_module实例对象
     * @returns {Prmoise<Object>} mc_sdk_module 实例对象
     */
    this.mc_util_mod_copy_msg = function (obj_copy_module) {
        return copy_msg(obj_copy_module);
    };
    /**
     *
     * @param {Promise<Number>} ui_mod_max_w 模组最大宽度
     * @param {Promise<Number>} ui_mod_max_h 模组最大高度度
     * @returns {Promise<Boolean>} 更新结果
     */
    this.mc_util_mod_updata_mod_size = function (ui_mod_max_w,ui_mod_max_h) {
        return updata_mod_size(ui_mod_max_w,ui_mod_max_h);
    };
    return true;
}
